require 'dxruby'
require_relative('data')

# 自キャラクラス--------------------------------------------------------------
class Me
  def public_method; end

  def initialize(x, y)
    @image = Image.load('pic/me.png')
    @x = x
    @y = y

    @hsw = @image.width/2
    @hsh = @image.height/2
  end # end of initialize

  def draw()
    Window.draw(@x-@hsw,@y-@hsh,@image)

    1.upto($unchi_list.length) do
      |i| $unchi_list[i-1].draw
    end

  end # end of draw

  def move()
    _x = Math.sqrt((@x.abs - Input.mousePosX.abs).abs)
    _y = Math.sqrt((@y.abs - Input.mousePosY.abs).abs)

    if ((@x.abs - Input.mousePosX.abs))> 0 then
      @x = @x - (_x/2).round
    else
      @x = @x + (_x/2).round
    end

    if ((@y.abs - Input.mousePosY.abs))> 0 then
      @y = @y - (_y/2).round
    else
      @y = @y + (_y/2).round
    end

    #画面内に収まるように
    if @x < 0 then
      @x=0
    end

    if @x > Window.width then
      @x = Window.width
    end

    if @y < 0 then
      @y=0
    end

    if @y > Window.height then
      @y = Window.height
    end

    # ウンチミサイルはっしゃ！
    _shot = true
    if Input.mousePush?(M_LBUTTON) and (!$water) then
      $oto.play(3)
      1.upto($unchi_list.length) do
        |i| if $unchi_list[i-1].kill_or_not then
          $unchi_list[i-1].renew(@x+@hsw,@y)
          _shot = false
          break
        end
      end
      if _shot then
        $unchi_list[$unchi_list.length] = Unchi.new(@x+@hsw,@y)
      end
    end

    1.upto($unchi_list.length) do
      |i| $unchi_list[i-1].move
    end

  end # end of move

  def getState
    return [@x-8, @y-8, @x+8, @y+8]
  end

end

# Unchiロード制御用-----------------------------------------------------------
class UM
  @@master_init = false
end

# ウンチ----------------------------------------------------------------------
class Unchi < UM
  def initialize(x,y)
    if @@master_init == false then
      @@image = Image.load('pic/crop.png')
      @@hsh = @@image.height/2
      @@hsw = @@image.width/2
      @@master_init = true
    end
    @x = x
    @y = y
    @mv = 0
    @kill = false
    @hit = false
  end # end of initialize

  def renew(x,y)
    @x = x
    @y = y
    @mv = 0
    @kill = false
    @hit = false
  end #end of renew

  def draw ()
    if !@kill then
      Window.draw(@x-@@hsw, @y-@@hsh, @@image)
    end
  end #end of draw

  def move()
    if @x>Window.width then
      @kill = true
    end

    if !@kill and !@hit then
      @mv+=1
      _mv = Math.sqrt(@mv).round
      if _mv > 16 then
        _mv = 16
      end
      @x+=_mv
    end

    if @hit then
      if @y>Window.height then
        @kill = true
      end
      if $water then
        @y += 8
      end
    end

  end # end of move

  def kill_or_not
    return @kill
  end # end of kill_or_not

  def getState
    return [@x-@@hsw+3, @y-@@hsh+3, @x-@@hsw+@@image.width-3, @y-@@hsh+@@image.height-3,@hit]
  end #end of getRect

  def hit # 一度当たったらあたり判定をなしにし、その場にとどまるようにするので。
    @hit = true
    @x+=12
  end # end of hit

end

# Enemyロード制御用-----------------------------------------------------------
class EM
  @@master_init = false
end

# 敵キャラクター--------------------------------------------------------------
class Enemy < EM
  def initialize()
    if @@master_init == false then
      @@image1 = Image.load('pic/japan.png')
      @@image2 = Image.load('pic/wes.png')
      @@wana = Image.load('pic/men.png')
      @@master_init = true
    end


    # 初期位置
    @x = 800
    @y = rand(Window.height-64)+32 #後で乱数を元に作り直すように。

    @youryou = (3 + rand(5))
    @ten_sumi = false

    # 動きのタイプ
    if rand(3) == 0 then
      @m_type = 0 # 真っ直ぐに進むだけ
    else
      @m_type = 1
      @m_hankei = rand(64)+32
      @m_bunkatu = rand(160) + 60
      @scnt = 0
      @y = rand(Window.height-(@m_hankei*2)-64)+32
      @base_y = @y
    end

    # 動きのスピード
    @speed = rand(3)+1

    # タイプ決定
    # c_type==0 の場合 罠
    case rand(9)
    when 0 then
      @c_type = 0
      @size = [@@wana.width, @@wana.height]
    when 1,2,3,4 then
      @c_type = 1
      @size = [@@image1.width, @@image1.height]
    else
      @c_type = 2
      @size = [@@image2.width, @@image2.height]
    end

    @hsw = @size[0]/2
    @hsh = @size[1]/2
    @kill = false
    @hit = 0  # いくつウンチ浮いてるか
  end # end of initialize

  def draw
    if @kill == false then
      if @c_type == 0 then
        Window.draw(@x-@hsw, @y-@hsh, @@wana)
      elsif @c_type == 1 then
        Window.draw(@x-@hsw, @y-@hsh, @@image1)
      else
        Window.draw(@x-@hsw, @y-@hsh, @@image2)
      end
    end
  end #end of draw


  def move()
    if @kill == false then
      if @hit == 0 then
        @x-=@speed
        if @m_type == 1 then
          @y = @base_y + (@m_hankei.to_f *
            Math.sin(2.0*Math::PI*@scnt.to_f/@m_bunkatu.to_f))
          @scnt += 1
          if @scnt > @m_bunkatu then
            @scnt = 0
          end
        end

        if (@x+@hsw)<0 then
          @kill = true
        end

      else
        if $water then
          # 点数、ゲームオーバー判定／処理
          if @youryou >= @hit then
            if !@ten_sumi then
              $score += @hit*@hit*$hit_benki
              @ten_sumi = true
            end
          else
            $game_over = true
            $go_riyu = 2
          end
          # 下水処理
          if (@y-@hsh) >= Window.height then
            @kill = true
          end
          @y+=8
        end
      end

      checkCollide
    end

  end # end of move

  def onHit
   return @hit
  end # end of onHit

  def checkCollide()
    for i in $unchi_list do
      if !i.kill_or_not and !i.getState[4] then
        if ((((@x-@hsw) <= i.getState[0]) and ((@x+@hsw) >= i.getState[0]) ) or
           ( ((@x-@hsw) <= i.getState[2]) and ((@x+@hsw) >= i.getState[2]))) and
           ((((@y-@hsh) <= i.getState[1]) and ((@y+@hsh) >= i.getState[1]) ) or
           ( ((@y-@hsh) <= i.getState[3]) and ((@y+@hsh) >= i.getState[3]))) then
           if @c_type == 0 then
             $game_over = true
             $go_riyu = 1
           else
             if @hit == 0 then
               $hit_benki += 1
             end
             @hit += 1
             i.hit
           end
        end
      end
    end

    # 時期と便器が接触
    if ((((@x-@hsw) <= $me.getState[0]) and ((@x+@hsw) >= $me.getState[0]) ) or
       ( ((@x-@hsw) <= $me.getState[2]) and ((@x+@hsw) >= $me.getState[2]))) and
       ((((@y-@hsh) <= $me.getState[1]) and ((@y+@hsh) >= $me.getState[1]) ) or
       ( ((@y-@hsh) <= $me.getState[3]) and ((@y+@hsh) >= $me.getState[3]))) and
       $water == false then
       $game_over = true
       $go_riyu = 0
    end

  end # end of checkCollide


  def kill_or_not
    return @kill
  end

end