#! /usr/bin/env python
# coding: utf-8
'''
Created on 2011/12/28

@author: YukiF
'''


import pygame,random
from pygame.locals import *
import data, util, s_result

class s_stage(object):
    def __init__(self):
        data.collide = 0
        
        self.bga1 = 20
        self.bga2 = 16
        self.bga3 = 23
        self.bga_cnt = 0

        self.myspeed = 0    #キャラクターのスピード
        self.myjump = 0     #ジャンプしたときのY位置
        self.jumpnow = False #ジャンプしてるかどうか 
        self.jumpcnt = 0
        
        self.myanim_cnt = 0 #アニメーションカウンタ
        self.myanim_pos = 128 #表示画像
        
        self.my = pygame.image.load("./img/my.png")
        self.myrect = pygame.Rect(300,370,40,64)    #自キャラあたり判定
        self.enem = []  #敵オブジェクトリスト
        
        self.over = pygame.image.load("./img/over.png")
        
        # 時間表示
        self.info = infomation()
        
        #画面切り替え時ディレイ
        self.delay = 90
    
    def draw(self):
        if self.info.time_zero:
            self.delay -=1
            data.screen.blit(self.over,[140,160])
            if self.delay == 0:
                data.scene_change = True
                data.scene_next = s_result.s_result()
        if self.myspeed > 0 :
            self.bg_anim(11-int(self.myspeed))
        self.bg_draw()
        
        self.enemy_grow()
        self.my_move()
        self.enemy_move()
        self.info.move(self.myspeed)
        
        self.my_anim()
        self.my_draw()
        self.info.draw()
        
        self.cllide()
    def my_move(self):
        #走る
        if self.myjump == 0:
            if pygame.mouse.get_pressed()[2] == 1:
                if self.myspeed<10:
                    self.myspeed += 0.05
                else:
                    self.myspeed = 10
            else:
                self.myspeed-=0.1
                if self.myspeed < 0:
                    self.myspeed = 0 
        #ジャンプ
        if data.mouse_state.pushL_Now():
            self.jumpnow = True
        
        if self.jumpnow:
            self.myjump = data.jump_hight[self.jumpcnt]
            self.jumpcnt+=1
            if len(data.jump_hight)<=self.jumpcnt:
                self.jumpcnt = 0
                self.jumpnow = False
        
        #自キャラの当たり判定を更新
        self.myrect=pygame.Rect(302,370-self.myjump,36,58)
        
    def my_anim(self):
        if self.jumpnow:
            self.my_anim_jump()
        else:
            self.my_anim_stop()
            self.my_anim_run()
        
    def my_anim_stop(self):
        #とまっている
        if self.myspeed == 0:
            self.myanim_pos= 128
            self.myanim_cnt = 0
        
        #あるいている
        if (self.myspeed > 0) and (int(self.myspeed)<=4):
            self.myanim_cnt += {0:0.1,
                                1:0.15,
                                2:0.20,
                                3:0.25,
                                4:0.30}[int(self.myspeed)]
            if int(self.myanim_cnt) >= 4:
                self.myanim_cnt=0
        
            self.myanim_pos = {0:0,
                               1:128,
                               2:64,
                               3:128}[int(self.myanim_cnt)]
    def my_anim_run(self):
        #はしっている
        if (int(self.myspeed) > 4) and (self.myspeed<=10):
            self.myanim_cnt += {5:0.25,
                                6:0.25,
                                7:0.30,
                                8:0.30,
                                9:0.35,
                                10:0.35}[int(self.myspeed)]
            if int(self.myanim_cnt) >= 8:
                self.myanim_cnt=0
        
            self.myanim_pos = {0:0,
                               1:384,
                               2:0,
                               3:128,
                               4:64,
                               5:448,
                               6:64,
                               7:128}[int(self.myanim_cnt)]
    
    def my_anim_jump(self):
        if self.jumpcnt < 19:
            self.myanim_pos = 256
        else:
            self.myanim_pos = 192
        pass
    
    #自キャラ描写
    def my_draw (self):
        data.screen.blit (self.my,[288,370-int(self.myjump)],
                          [self.myanim_pos,0,64,64])
 
    #敵が発生
    def enemy_grow(self):
        for i in range(len(self.enem)):
            if self.enem[i-1].die:
                del self.enem[i-1]

        if self.myspeed<=0 :
            return
        
        if len(self.enem)<3:
            for i in self.enem:
                if i.pc < 20:
                    return
            if int(random.uniform(0,self.info.enemy_freq()))==1:
                self.enem.append(enemy())

    
    #敵が移動
    def enemy_move(self):
        for i in self.enem:
            i.move(self.myspeed)
            i.draw()

 
    #当たり判定
    def cllide(self):
        for i in self.enem:
            if i.collide(self.myrect):
                data.rem_time_view -= 3
                data.collide += 1
        
    def bg_draw(self):
        util.bgDraw(self.bga1)
        util.bgDraw(self.bga2)
        util.bgDraw(self.bga3)
        
    def bg_anim(self,speed):
        if self.bga_cnt >= speed:
            # 背景アニメーション
            if self.bga1 == 20:
                self.bga1 = 21
            else:
                self.bga1 = 20
            
            if self.bga2 == 16:
                self.bga2 = 17
            elif self.bga2 == 17:
                self.bga2 =18
            else:
                self.bga2 = 16
    
            if self.bga3 == 23:
                self.bga3 = 24
            elif self.bga3 == 24:
                self.bga3 = 25
            elif self.bga3 == 25:
                self.bga3 =26
            else:
                self.bga3 = 23
            self.bga_cnt = 0
            return
        self.bga_cnt+=1
        


#残り時間,距離の表示
class infomation(object):
    def __init__(self):
        self.t_img = pygame.image.load("./img/hyoji.png")
        self.time_cnt = 30
        data.rem_time_view = 60
        data.rem_time_cnt = 30*60
        data.distance = 0
        self.time_zero = False
        pass
    
    def move(self,speed):
        if data.rem_time_view <= 0:
            data.rem_time_viwe = 0
            self.time_zero = True
            return
        self.time_cnt-=1
        data.rem_time_cnt-=1
        if self.time_cnt == 0:
            self.time_cnt = 30
            data.rem_time_view -= 1
        if data.rem_time_view <= 0:
            data.rem_time_viwe = 0
            self.time_zero = True
        data.distance += (speed/5)
    
    def enemy_freq(self): #時間が経つほど敵の出現頻度が上がるように
        if data.rem_time_cnt > 120:
            return 40
        elif data.rem_time_cnt > 60:
            return 27
        else:
            return 15
    
    def draw(self):
        self.time_draw(10, 10)
        self.dist_draw(10, 48)
        pass
    
    def time_draw(self,px,py):
        data.screen.blit(self.t_img,[px,py],[288,0,96,32])  # 「残り時間」 
        if data.rem_time_view<0:
            data.rem_time_view = 0
        for i in range(len(str(data.rem_time_view))):       # 「数字」
            data.screen.blit(self.t_img,[px+96+(i*24),py],[int(str(data.rem_time_view)[i])*24,0,24,32])
    
    def dist_draw(self,px,py):
        for i in range(len(str(int(data.distance)))):
            data.screen.blit(self.t_img,[px+(i*24),py],[int(str(int(data.distance))[i])*24,0,24,32])
        data.screen.blit(self.t_img,[px+(len(str(int(data.distance)))*24),py],[256,0,32,32])
    
#敵クラス
class enemy(object):
    def __init__(self):
        self.pc = 0     #テーブルに対するポインタ
        self.ppc = 0    #前のポインタ位置
        self.sizew = random.uniform(16,96)  #サイズをランダムで生成する
        self.sizeh = random.uniform(32,96)
        self.hsizew = self.sizew//2         #中心座標を取るために半分のサイズを持っておく
        self.hsizeh = self.sizeh//2
        self.mx = 0 #移動量
        self.my = 0
        
        self.rect = pygame.Rect(data.enemy_pos_x[self.pc]-self.hsizew,
                           data.enemy_pos_y[self.pc]-self.hsizeh,
                           self.sizew, self.sizeh)
        self.die = False
        self.col = False    #衝突が発生した際、Trueに。
        
    #あたり判定、描画ようのRectを更新
    def update_rect(self):
        self.mx = data.enemy_pos_x[self.pc] - data.enemy_pos_x[self.ppc]
        self.my = data.enemy_pos_y[self.pc] - data.enemy_pos_y[self.ppc]
        self.rect.move_ip(self.mx, self.my)
        if self.col:
            self.rect.inflate_ip(50,50)
    
    # 自機スピードを受け取ってそれを基準にテーブルから位置取得
    # テーブルの端より大きい位置にポインタが来たら死亡スイッチ入れる
    def move(self,speed):
        self.update_rect()
        self.ppc = self.pc
        if speed == 0:
            return
        if speed < 1:
            self.pc += 1
            if self.pc >= len(data.enemy_pos_x):
                self.die = True
            return
        self.pc += int(speed)
        if self.pc >= len(data.enemy_pos_x):
            self.die = True

    # 描写
    def draw(self):
        pygame.draw.rect(data.screen,data.COLOR["BLACK"],self.rect,1)

    def collide(self,r):
        if self.col:    #一度衝突が発生すると次は発生しない
            return False
        if self.rect.colliderect(r):
            self.col = True
            return True
        else:
            return False