#! /usr/bin/env python
# coding: utf-8

'''
Created on 2011/12/27

@author: YukiF
'''

import math
import pygame
from pygame.locals import *
import data

def keyDown(event, key):
    if (event.type == KEYDOWN and event.key == key):
        return True
    else:
        return False

def keyRel(event, key):
    if (event.type == KEYUP and event.key == key):
        return True
    else:
        return False


def bgDraw (reso):
    for cnt in range(reso//2):
        pygame.draw.line(data.screen, data.COLOR["BLACK"],
                         [math.cos(math.pi*2*(cnt)/reso)*360+320,math.sin(math.pi*2*(cnt)/reso)*360+80],
                         [math.cos(math.pi*2*(cnt+1)/reso)*360+320,math.sin(math.pi*2*(cnt+1)/reso)*360+80])

class mouseState (object):
    def __init__(self):
        #現在のマウスの状態
        self.pos = (0,0)
        self.key = (0,0,0)
        
        #前フレームのマウスの状態
        self.prev_pos = (0,0)
        self.prev_key = (0,0,0)
        
    def getState(self):
        self.prev_pos = self.pos
        self.pos = pygame.mouse.get_pos()
        self.prev_key = self.key
        self.key = pygame.mouse.get_pressed()
 
    #今キーが押された
    def pushL_Now(self):
        if (self.key[0]==1) and (self.prev_key[0]==0):
            return True
        else:
            return False
    
    def pushR_Now(self):
        if (self.key[2]==1) and (self.prev_key[2]==0):
            return True
        else:
            return False
    
    #今キーが離された
    def relL_Now(self):
        if (self.key[0]==0) and (self.prev_key[0]==1):
            return True
        else:
            return False

    def relR_Now(self):
        if (self.key[2]==0) and (self.prev_key[2]==1):
            return True
        else:
            return False

